select b.date,b.member_id,b.center_id,b.zone_id,b.saving_transaction_id,b.dps_transaction_id,b.loan_transaction_id,b.area_id,b.loan_account_id,b.saving_account_id,b.dps_account_id,b.transaction_type,b.account_type,
sum(l.amount) as loan_amount, 
sum(sd.amount) as saving_amount_daily, 
sum(sw.amount) as saving_amount_weekly,
sum(sm.amount) as saving_amount_month,
sum(d.amount) as dps_amount 
from balance b 
left join loan_transaction l on (l.transaction_id=b.loan_transaction_id)
left join saving_account_transaction as sd on (sd.transaction_id=b.saving_transaction_id and sd.account_type=1)
left join saving_account_transaction as sw on (sw.transaction_id=b.saving_transaction_id and sw.account_type=2)
left join saving_account_transaction as sm on (sm.transaction_id=b.saving_transaction_id and sm.account_type=3)
left join dps_account_transaction  as d on (d.transaction_id=b.dps_transaction_id) 
group by b.date, b.member_id
having (
loan_amount is not null
or saving_amount_daily is not null
or saving_amount_weekly is not null
or saving_amount_month is not null
)





